<?php
$classes = [
    'vendor/laravel/framework/src/Illuminate/Support/Arr.php',
    'vendor/laravel/framework/src/Illuminate/Support/Str.php',
    'vendor/laravel/framework/src/Illuminate/Http/Request.php',
    'app/User.php', // Add your most-used models
    'app/Account.php',
    'app/AccountTransaction.php',
    'app/AccountType.php',
    'app/Barcode.php',
    'app/Brands.php',
    'app/Business.php',
    'app/BusinessLocation.php',
    'app/CashDenomination.php',
    'app/CashRegister.php',
    'app/CashRegisterTransaction.php',
    'app/Category.php',
    'app/Contact.php',
    'app/Currency.php',
    'app/CustomerGroup.php',
    'app/DashboardConfiguration.php',
    'app/Discount.php',
    'app/DocumentAndNote.php',
    'app/ExpenseCategory.php',
    'app/GroupSubTax.php',
    'app/InvoiceLayout.php',
    'app/InvoiceScheme.php',
    'app/Media.php',
    'app/NotificationTemplate.php',
    'app/PaymentAccount.php',
    'app/Printer.php',
    'app/Product.php',
    'app/ProductRack.php',
    'app/ProductVariation.php',
    'app/PurchaseLine.php',
    'app/ReferenceCount.php',
    'app/SellingPriceGroup.php',
    'app/StockAdjustmentLine.php',
    'app/System.php',
    'app/TaxRate.php',
    
    // Frequently used service classes
        // ======== YOUR CONTROLLERS ========
    'app/Http/Controllers/AccountController.php',
    'app/Http/Controllers/AccountReportsController.php',
    'app/Http/Controllers/AccountTypeController.php',
    'app/Http/Controllers/BackUpController.php',
    'app/Http/Controllers/BarcodeController.php',
    'app/Http/Controllers/BrandController.php',
    'app/Http/Controllers/BusinessController.php',
    'app/Http/Controllers/BusinessLocationController.php',
    'app/Http/Controllers/CashRegisterController.php',
    'app/Http/Controllers/CombinedPurchaseReturnController.php',
    'app/Http/Controllers/ContactController.php',
    'app/Http/Controllers/Controller.php',
    'app/Http/Controllers/CustomerGroupController.php',
    'app/Http/Controllers/DashboardConfiguratorController.php',
    'app/Http/Controllers/DiscountController.php',
    'app/Http/Controllers/DocumentAndNoteController.php',
    'app/Http/Controllers/ExpenseCategoryController.php',
    'app/Http/Controllers/ExpenseController.php',
    'app/Http/Controllers/GroupTaxController.php',
    'app/Http/Controllers/HomeController.php',
    'app/Http/Controllers/ImportOpeningStockController.php',
    'app/Http/Controllers/ImportProductsController.php',
    'app/Http/Controllers/ImportSalesController.php',
    'app/Http/Controllers/InvoiceLayoutController.php',
    'app/Http/Controllers/InvoiceSchemeController.php',
    'app/Http/Controllers/LabelsController.php',
    'app/Http/Controllers/LedgerDiscountController.php',
    'app/Http/Controllers/LocationSettingsController.php',
    'app/Http/Controllers/ManageUserController.php',
    'app/Http/Controllers/MyFatoorahController.php',
    'app/Http/Controllers/NotificationController.php',
    'app/Http/Controllers/NotificationTemplateController.php',
    'app/Http/Controllers/OpeningStockController.php',
    'app/Http/Controllers/PesaPalController.php',
    'app/Http/Controllers/PrinterController.php',
    'app/Http/Controllers/ProductController.php',
    'app/Http/Controllers/PurchaseController.php'
    // Add more frequently used classes
];

foreach ($classes as $file) {
    if (file_exists(__DIR__.'/'.$file)) {
        opcache_compile_file(__DIR__.'/'.$file);
    }
}

